/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-2002 Parametric Technology Corporation.
	All rights reserved.
*/

// centerAxes conv functions
#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"


HRESULT centerAxesPrior()
{
	START_METHOD("CenterAxesPrior")

	HRESULT status = CONV_SUCCESS;	
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Select entities for Center Axes");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *pselectionset = NULL;

	status = activeGraphicDoc->GetSelection(GetBSTR("Geometric" ), &pselectionset);
	CHECK_RETURN_STATUS(status)

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(pselectionset, &pObjectIt);
	CHECK_RETURN_STATUS(status);

	IDispatch *pDispObject = NULL;
	IGeometric *pFirstGeometric = NULL;
	IGeometric *pSecondGeometric = NULL;

	status = pObjectIt->start(&pDispObject);
	CHECK_RETURN_STATUS(status)
	pFirstGeometric = CAST(IGeometric, pDispObject);

	status = pObjectIt->Next(&pDispObject);
	CHECK_RETURN_STATUS(status)
	pSecondGeometric = CAST(IGeometric, pDispObject);

	status = CenterAxes(pFirstGeometric, pSecondGeometric);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Center Axes");
	CHECK_RETURN_STATUS(status)

	END_METHOD("CenterAxesPrior")
}
